<?php
///////////////////////////////////////////////////////////////////////////////
// File: admin.php
// Purpose: administrator control panel
// Remarks: requires common.php
///////////////////////////////////////////////////////////////////////////////
// Functions:
//		string auth_user(string $userid, string $password)
//		void login_form()
//		void admin_panel()
///////////////////////////////////////////////////////////////////////////////

require("./common.php");

session_start();

///////////////////////////////////////////////////////////////////////////////
// Function: string auth_user(string $userid, string $password)
// Purpose: attempts to authenticate user
// Parameters:
//		$userid - user id
//		$password - user password
// Returns: user id upon success; 0 upon error
// Global references:
//		$HTTP_POST_VARS
//		$admin_table - name of table containing admin login info
///////////////////////////////////////////////////////////////////////////////
function auth_user($userid, $password)
{
	global $HTTP_POST_VARS;
	global $admin_table;

	$userid=$HTTP_POST_VARS['userid'];
	$password=$HTTP_POST_VARS['password'];

	db_connect();

	$query="SELECT userid "
					."FROM $admin_table "
					."WHERE userid='$userid' AND password=password('$password')";
	$result=mysql_query($query);

	if(!mysql_num_rows($result))
	// no matches
	{
		return 0;
	}
	else
	// match found so return userid
	{
		$query_data=mysql_fetch_array($result);
		return $query_data['userid'];
	}
}// end auth_user()

///////////////////////////////////////////////////////////////////////////////
// Function: void login_form()
// Purpose: displays form for authenticating administrator access
// Parameters: none
// Returns: nothing
// Global references:
//		$PHP_SELF
//		$HTTP_POST_VARS
///////////////////////////////////////////////////////////////////////////////
function login_form()
{
	global $PHP_SELF;
	global $HTTP_POST_VARS;
?>
<div align="center">
<h1>Admin Panel</h1>
<form name="admin_form" method="post" action="<?php echo $PHP_SELF; ?>">
<input name="action" type="hidden" value="authenticate">

<!-- form table -->
<table width="<?=$GLOBALS['OB_table_width']?>" cellspacing="1" cellpadding="5">
	<tr>
		<th colspan="2">Please login to access administrative functions.
	</tr>
	<tr>
		<th width="20%" align="right">User ID:</th>
		<td><input name="userid" type="text" size="20" value="<?php if(isset($HTTP_POST_VARS['userid'])) echo $HTTP_POST_VARS['userid'];?>"></td>
	</tr>
	<tr>
		<th width="20%" align="right">Password:</th>
		<td><input name="password" type="password" size="20"></td>
	</tr>
	<tr>
		<td class="buttons" colspan="2"><input type="submit" value="Login"> <a href="./forgotpass.php">Forgot your password?</a></td>
	</tr>
	<tr>
		<td class="links" colspan="2"align="right">Back to <a href="./index.php">guestbook</a></td>
	</tr>
</table>
<!-- END form table -->

</form>
</div>
<?php
}// end login_form()

///////////////////////////////////////////////////////////////////////////////
// Function: void admin_panel()
// Purpose: displays admin panel
// Parameters: none
// Returns: nothing
// Global references:
//		$HTTP_SESSION_VARS
///////////////////////////////////////////////////////////////////////////////
function admin_panel()
{
	global $HTTP_SESSION_VARS;
	pageheader("{$GLOBALS['sitename']} - Admin Panel");
?>
<div align="center">
<h1>Admin Panel</h1>

<table width="<?=$GLOBALS['OB_table_width']?>" cellspacing="1" cellpadding="5">
	<tr>
		<th>Logged in as <span class="adminname"><?php echo $HTTP_SESSION_VARS['admin_name']; ?></span> <a href="./logout.php">[Logout]</th>
	</tr>
	<tr>
		<td class="links"><a href="./index.php">[View your guestbook]</a> | <a href="./profile.php">[Change your profile]</a> | <a href="./create_admin.php">[Create another admin account]</a></td>
	</tr>
</table>
</div>
<?php
	pagefooter();
}// end admin_panel()


///////////////////////////////////////////////////////////////////////////////
// script main
///////////////////////////////////////////////////////////////////////////////
if(isset($HTTP_SESSION_VARS['admin_name']))
// IMPT: check if user is administrator first
{
	admin_panel();
}
else
// user is NOT logged in as administrator
{
	if(!isset($HTTP_POST_VARS['userid']))
	// userid field not set means user has not seen form yet
	{
		pageheader("$sitename - Admin Panel","onLoad=\"document.forms['admin_form'].elements['userid'].focus()\"");
		login_form();
		pagefooter();
		exit;
	}
	else
	// attempt to authenticate user
	{
		$userid=$HTTP_POST_VARS['userid'];
		$password=$HTTP_POST_VARS['password'];

		session_register("userid", "password");	// register session variables

		$empty_userid=0;	// flag to indicate userid field empty
		$empty_password=0;	// flag to indicate password field empty

		if(empty($userid))
		{
			$empty_userid=1;
		}
		if(empty($password))
		{
			$empty_password=1;
		}

		$admin_name=auth_user($userid, $password);  // auth_user() will return userid if successful
		if(!$admin_name)
		// authentication failed
		{
			session_unregister("userid");
			session_unregister("password");

			pageheader("$sitename - Authorization failed");

			echo "<div align=\"center\">\n";
			echo "<h1>Authorization failed</h1>\n";

			if($empty_userid)
			{
				echo "<span class=\"error\">You did not enter a User ID!</span><br />\n";
			}
			if($empty_password)
			{
				echo "<span class=\"error\">You did not enter a password!</span><br />\n";
			}

			echo "Authorization failed.<br />\n";
			echo "You must enter a valid userid and password.<br />\n";
			echo "<a href=\"./admin.php\">Try again</a> | <a href=\"index.php\">Back to Guestbook</a>\n";
			echo "</div>\n";
			pagefooter();
			exit;
		}
		else
		// authentication successful
		{
			session_register("admin_name");

			header("Location: ./admin.php");
		}
	}
}
?>