<?php
///////////////////////////////////////////////////////////////////////////////
// File: common.php
// Purpose: contains common variables and functions
// Remarks: make configuration changes to this file to suit your tastes
///////////////////////////////////////////////////////////////////////////////
// Functions:
//		void pageheader(string $title="OpenBook", string $body_attr="")
//		void redirectheader(string $url="./index.php", int $delay="2")
//		void pagefooter()
//		mysql_link_id db_connect()
//		void error_msg(string $msg)
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Variables
///////////////////////////////////////////////////////////////////////////////
// database settings
$dbhost="localhost";		// database host address
$dbuser="root";				// database user name
$dbpassword="";				// database password
$default_db="openbook";		// name of database

// table names
$posts_table="openbook_posts";	// name of table to store posts
$admin_table="openbook_admin";	// name of table for admin authentication

// global variables
$sitename="OpenBook";		// default title of pages
$OB_version="1.2.2";		// version of OpenBook
$DOMAIN_URL="../";			// fully qualified URL of homepage; defaults to 1 level above guestbook directory

// guestbook settings
$OB_entries_per_page="5";	// number of entries to display per page
$OB_table_width="55%";		// width of tables
$OB_display_type="openbook";	// type of display structure for entries: "conventional" or "openbook"
$OB_css="style.css";		// CSS file to use
$OB_mail_to_admin=true;		// set to true to enable email notification to administrator; requires proper PHP email configuration (eg. sendmail)


///////////////////////////////////////////////////////////////////////////////
// Function: void pageheader(string $title="OpenBook", string $body_attr="")
// Purpose: echoes html page header
// Parameters:
//		$title - title of page (default: OpenBook)
//		$body-attr - additional body attributes (default: empty string)
// Returns: nothing
// Global references: none
///////////////////////////////////////////////////////////////////////////////
function pageheader($title="OpenBook", $body_attr="")
{
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
	<title><?=$title?></title>
	<meta http-equiv="pragma" content="no-cache">
	<meta http-equiv="expires" content="-1">
	<meta http-equiv="cache-control" content="no-cache">
	<link rel="stylesheet" type="text/css" href="<?=$GLOBALS['OB_css']?>">
</head>
<body <?=$body_attr?>>
<?php
}// end pageheader()

///////////////////////////////////////////////////////////////////////////////
// Function: void redirectheader(string $url="./index.php", int $delay=2)
// Purpose: html page header for redirection
// Parameters:
//		$url - URL to redirect to (default: ./index.php)
//		$delay - time in seconds to wait before redirection (default: 2)
// Returns: nothing
// Global references:
//		$sitename - name of site
///////////////////////////////////////////////////////////////////////////////
function redirectheader($url="./index.php", $delay="2")
{
?>
<html>
<head>
	<title><?=$GLOBALS['sitename']?></title>
	<meta http-equiv="refresh" content="<?=$delay?>; url=<?=$url?>">
	<link rel="stylesheet" type="text/css" href="style.css">
</head>
<body>
<?php
}// end redirectheader()

///////////////////////////////////////////////////////////////////////////////
// Function: void pagefooter()
// Purpose: html page footer
// Parameters: none
// Returns: nothing
// Global references:
//		$OB_version - version of OpenBook
///////////////////////////////////////////////////////////////////////////////
function pagefooter()
// page footer
{
?>
<br />

<!-- ATTENTION: It is my sincere request that the footer information below not be modified or removed. This is to provide users with a link to the OpenBook homepage where they can download OpenBook if they like what they see :) -->
<div class="footer" align="center">
<a href="http://openbook.sourceforge.net">OpenBook</a> version <?=$GLOBALS['OB_version']?>
<br />
A project by redemption
</div>
</body>
</html>
<?php
}// end pagefooter()

///////////////////////////////////////////////////////////////////////////////
// Function: mysql_link_id db_connect()
// Purpose: connects to db server and selects $default_db
// Parameters: none
// Returns: MySQL link identifier upon success; dies upon error
// Global references:
//		$dbhost - database host address
//		$dbuser - database user name
//		$dbpassword - database password
//		$default_db - name of database
///////////////////////////////////////////////////////////////////////////////
function db_connect()
{
	global $dbhost, $dbuser, $dbpassword, $default_db;

	$link_id=@mysql_connect($dbhost,$dbuser,$dbpassword);
	if(!$link_id)
	// connection to server failed
	{
		die("Connection failed to $dbhost.");
	}
	if(!@mysql_select_db($default_db,$link_id))
	// select db to use
	{
		die("Couldn't select database $default_db.");
	}
	return $link_id;
}// end db_connect()

///////////////////////////////////////////////////////////////////////////////
// Function: void not_logged_error()
// Purpose: displays page to indicate not logged in
// Parameters: none
// Returns: nothing
// Global references: none
///////////////////////////////////////////////////////////////////////////////
function not_logged_error()
{
	pageheader($GLOBALS['sitename']);
?>
<div align="center">
<h1>Permission denied</h1>
<span class="error">You're not logged in!</span>
<br />
<a href="./admin.php">[Login]</a> | <a href="./index.php">[Back to guestbook]</a>
</div>
<?php
}// end not_logged_error()

///////////////////////////////////////////////////////////////////////////////
// Function: double get_microtime()
// Purpose: gets the current time in microseconds
// Parameters: none
// Returns: current time in microseconds
// Global references: none
///////////////////////////////////////////////////////////////////////////////
function get_microtime()
{
	$time=microtime();
	$time=explode(" ",$time);		// microtime() returns seconds and microseconds in
															// a string separated by a space
	$time=doubleval($time[1]) + doubleval($time[0]);

	return $time;
}// end get_microtime()

///////////////////////////////////////////////////////////////////////////////
// Function: void error_msg(string $msg)
// Purpose: prints error msg in error style
// Parameters:
//		$msg - error message to display
// Returns: nothing
// Global references: none
///////////////////////////////////////////////////////////////////////////////
function error_msg($msg)
{
 	echo "<span class=\"error\">$msg</span><br />";
}// end error_msg()