<?php
///////////////////////////////////////////////////////////////////////////////
// File: edit.php
// Purpose: for administrator to edit/delete guestbook entry as well as reply to guestbook entries
// Remarks: 1. requires common.php
//			2. Default: display form
//				"Edit entry": attempts to update entry
//				"Delete entry": attempts to delete entry
///////////////////////////////////////////////////////////////////////////////
// Functions: none
///////////////////////////////////////////////////////////////////////////////

require("./common.php");

session_start();

if(isset($HTTP_SESSION_VARS['admin_name']))
// IMPT: check if user is administrator first
{
	if(isset($HTTP_POST_VARS['action']) && $HTTP_POST_VARS['action']=="Edit entry")
	// EDIT ENTRY: process confirmation of edit
	{
		$new_username=addslashes(htmlentities($HTTP_POST_VARS['new_username']));
		$new_useremail=htmlentities($HTTP_POST_VARS['new_useremail']);
		$new_homepage=addslashes(htmlentities($HTTP_POST_VARS['new_homepage']));
		$new_subject=addslashes(htmlentities($HTTP_POST_VARS['new_subject']));
		$new_message=addslashes(htmlentities($HTTP_POST_VARS['new_message']));
		$new_reply=addslashes(htmlentities($HTTP_POST_VARS['new_reply']));
		$postdate=$HTTP_POST_VARS['postdate'];
		$entryid=$HTTP_POST_VARS['entryid'];

		$link_id=db_connect();

		$query="UPDATE $posts_table "
				."SET username='$new_username', "
				."useremail='$new_useremail', "
				."homepage='$new_homepage', "
				."subject='$new_subject', "
				."message='$new_message', "
				."postdate=$postdate, "
				."reply='$new_reply' "
				."WHERE entryid=$entryid";
		$result=mysql_query($query);

		if(mysql_affected_rows($link_id) == 1)
		{
			redirectheader("./index.php?page={$HTTP_POST_VARS['page']}");
			echo "<div align=\"center\">\n";
			echo "<h1>$sitename - Editing entry</h1>\n";
			echo "All changes have been saved!<br /><br />\n";
			echo "You'll be taken back to the page you came from.<br />\n";
			echo "Alternatively, you can click <a href=\"./index.php?page={$HTTP_POST_VARS['page']}\">here</a> if you can't wait.\n";
			echo "</div>\n";
		}
		else if(mysql_affected_rows($link_id) == 0)
		{
			redirectheader("./index.php?page={$HTTP_POST_VARS['page']}");
			echo "<div align=\"center\">\n";
			echo "<h1>$sitename - Editing entry</h1>\n";
			echo "<span class=\"error\">You've made no changes!</span><br /><br />\n";
			echo "You'll be taken back to the page you came from.<br />\n";
			echo "Alternatively, you can click <a href=\"./index.php?page={$HTTP_POST_VARS['page']}\">here</a> if you can't wait.\n";
			echo "</div>\n";
		}
		else
		{
			pageheader("$sitename - Error");

			echo "<div align=\"center\">\n";
			echo "<h1>Error</h1>\n";
			echo "<span class=\"error\">An error has occurred! Entry NOT updated!</span>\n";
			echo "<br />\n";
			echo "Back to <a href=\"./index.php\">Guestbook</a>\n";
			echo "</div>\n";
		}
	}
	else if(isset($HTTP_POST_VARS['action']) && $HTTP_POST_VARS['action']=="Delete entry")
	// DELETE ENTRY: process confirmation of deletion
	{
		$link_id=db_connect();

		$entryid=$HTTP_POST_VARS['entryid'];

		$query="DELETE FROM $posts_table
				WHERE entryid=$entryid";
		$result=mysql_query($query);

		if(mysql_affected_rows($link_id) == 1)
		{
			redirectheader("./index.php?page={$HTTP_POST_VARS['page']}");
			echo "<div align=\"center\">\n";
			echo "<h1>$sitename - Deleting entry</h1>\n";
			echo "Entry deleted!<br /><br />\n";
			echo "You'll be taken back to the page you came from.<br />\n";
			echo "Alternatively, you can click <a href=\"./index.php?page={$HTTP_POST_VARS['page']}\">here</a> if you can't wait.\n";
			echo "</div>\n";
		}
		else
		{
			pageheader("$sitename - Error");

			echo "<div align=\"center\">\n";
			echo "<h1>Error</h1>\n";
			echo "<span class=\"error\">An error has occurred! Entry NOT deleted!</span>";
			echo "<br />\n";
			echo "Back to <a href=\"./index.php\">Guestbook</a>\n";
			echo "</div>\n";
		}
	}
	else
	// Default action: display form for editing/deleting entry
	{
		db_connect();

		$entryid=$HTTP_GET_VARS['entryid'];

		$query="SELECT username,useremail,homepage,subject,message,date_format(postdate,'%D %b %Y, %r') AS date,postdate, reply 
			FROM $posts_table
			WHERE entryid=$entryid";
		$result=mysql_query($query);  // retrieve selected entry from db

		pageheader("$sitename - Editing entry");

		echo "<center><h1>Editing guestbook entry</h1></center>";

		if($entry=mysql_fetch_array($result))
		// entry exists
		// display entry and ask for confirmation
		{
	?>
<div align="center">
<form method="post" action="<?=$PHP_SELF?>">
<input name="entryid" type="hidden" value="<?=$entryid?>" />
<input name="postdate" type="hidden" value="<?=$entry['postdate']?>" />
<input name="page" type="hidden" value="<?=$HTTP_GET_VARS['page']?>" />

<!-- entry table -->
<table width="<?=$GLOBALS['OB_table_width']?>" cellspacing="1" cellpadding="5">
	<tr>
		<th align="left">Entry dated: <?=$entry['date']?></td>
	</tr>
	<tr>
		<td class="subject">Subject: <input name="new_subject" type="text" size="25" maxlength="40" value="<?=$entry['subject']?>"></td>
	</tr>
	<tr>
		<td class="subject">Message:<br /><textarea name="new_message" rows="5" cols="50"><?=$entry['message']?></textarea></td>
	</tr>
	<tr>
		<td class="subject" align="right">Email address: <input name="new_useremail" type="text" size="30" maxlength="40" value="<?=$entry['useremail']?>"></td>
	</tr>
	<tr>
		<td class="subject" align="right">Homepage: http://<input name="new_homepage" type="text" size="30" maxlength="50" value="<?=$entry['homepage']?>"></td>
	</tr>
	<tr>
		<td class="subject" align="right">Posted by: <input name="new_username" type="text" size="20" maxlength="30" value="<?=$entry['username']?>"></td>
	</tr>
	<tr>
		<td class="reply">Reply to guestbook entry:<br /><textarea name="new_reply" rows="5" cols="50"><?php if(isset($entry['reply'])) echo $entry['reply']; ?></textarea></td>
	</tr>
	<tr>
		<td class="buttons" align="center">
			<input name="action" type="submit" value="Edit entry">
			<input name="action" type="submit" value="Delete entry">
			<input type="button" onClick="history.go(-1);" value="Cancel">
		</td>
	</tr>
</table>
<!-- END entry table -->

</div>
		<?php
		}
		else
		// entry doesn't exist or cannot be retrieved
		{
			pageheader("$sitename - Editing entry");

			echo "\n<span class=\"error\">Selected entry does not exist or cannot be retrieved.</span>\n";
			echo "<br /><br />\n";
			echo "<input type=\"button\" onClick=\"history.go(-1);\" value=\"Go Back\">\n";
		}
	}
}
else
// user is NOT logged in as administrator\
{
	not_logged_error();
}

pagefooter();
?>