<?php
///////////////////////////////////////////////////////////////////////////////
// File: forgotpass.php
// Purpose: "Forgot your password?" handler; sends email with new password to specified admin account
// Remarks: requires common.php
///////////////////////////////////////////////////////////////////////////////
// Functions:
//		void forgot_form()
//		string generate_pass(int)
//		void generate_and_send()
///////////////////////////////////////////////////////////////////////////////

require("./common.php");

///////////////////////////////////////////////////////////////////////////////
// Function: void forgot_form()
// Purpose: displays form for "Forgot your password?" request
// Parameters: none
// Returns: nothing
// Global references:
//		$PHP_SELF
///////////////////////////////////////////////////////////////////////////////
function forgot_form()
{
	global $PHP_SELF;
?>
<div align="center">
<h1>Forgot your password?</h1>
<form name="forgot_form" method="post" action="<?php echo $PHP_SELF; ?>">
<input name="action" type="hidden" value="generate">

<!-- form table -->
<table width="<?=$GLOBALS['OB_table_width']?>" cellspacing="1" cellpadding="5">
	<tr>
		<th colspan="2">Please enter the User ID for your account.<br />A new password will be generated and sent to your registered email address.
	</tr>
	<tr>
		<th width="20%" align="right">User ID:</th>
		<td><input name="userid" type="text" size="20"></td>
	</tr>
	<tr>
		<td class="buttons" colspan="2"><input type="submit" value="Submit"></td>
	</tr>
	<tr>
		<td class="links" colspan="2" align="right">Back to <a href="./index.php">Guestbook</a> | <a href="./admin.php">Admin Panel</a>
		</td>
	</tr>
</table>
<!-- END form table -->

</form>
</div>
<?php
}// end forgot_form()

///////////////////////////////////////////////////////////////////////////////
// Function: string generate_pass(int $length)
// Purpose: generates a random 8 character alphanumeric password; the characters l,1,0,o are omitted because they look like each other and may confuse the user
// Parameters: none
// Returns: 8 character alphanumeric string
// Global references: none
///////////////////////////////////////////////////////////////////////////////
function generate_pass($length=8)
{
	$passkey="";
	$alphanum_array = explode(" ", 
				"a b c d e f g h j k m n p q r s t w x y z "
				."A B C D E F G H J K L M N P Q R S T W X Y Z "
				."2 3 4 5 6 7 8 9");

	for($i=0; $i<$length; $i++) 
	{
		mt_srand((double)microtime()*1000000);	// seed the better random number generator
		$randNum=mt_rand(0,50);  // generate random value from 0 to 50 (size of array)
		$passkey.=$alphanum_array[$randNum];
	} 
	return $passkey;
}// end generate_pass()

///////////////////////////////////////////////////////////////////////////////
// Function: void generate_and_send()
// Purpose: generates a new password for the specified admin account and sends it in an email to the registered email address
// Parameters: none
// Returns: nothing
// Global references:
//		$PHP_SELF
//		$HTTP_POST_VARS
//		$admin_table
///////////////////////////////////////////////////////////////////////////////
function generate_and_send()
{
	global $PHP_SELF;
	global $HTTP_POST_VARS;
	global $admin_table;
?>	
<div align="center">
<h1>Forgot your password?</h1>
<table width="<?=$GLOBALS['OB_table_width']?>" cellspacing="1" cellpadding="5">
	<tr>
		<th>
<?php
	db_connect();
	$query="SELECT email FROM $admin_table WHERE userid='${HTTP_POST_VARS['userid']}'";
	$result=mysql_query($query);
	if(mysql_num_rows($result)==0)
	// User ID does not exist
	{
		echo "<span class=\"error\">The User ID <b>${HTTP_POST_VARS['userid']}</b> does not exist in our records.</span>";
	}
	else
	// generate a new password and send it in an email to registered email address
	{
		$new_password=generate_pass();

		$query="UPDATE $admin_table SET password=PASSWORD('$new_password') "
				."WHERE userid='${HTTP_POST_VARS['userid']}'";
		mysql_query($query);

		$row=mysql_fetch_row($result);
		$mail_to=$row[0];

		// mail-to-admin variables
		$mail_subject="Your new OpenBook admin password";

		$mail_body="You or someone pretending to be you has requested a new password for your OpenBook administration account. Your new password now is:\n\n";
		$mail_body.="User ID: ".$HTTP_POST_VARS['userid']."\n\n";
		$mail_body.="Password: ".$new_password."\n\n\n";
		
		$mail_headers="From: OpenBook Mailer <no-reply@openbook.mailer>\n";
		$mail_headers.="X-Mailer: OpenBook Mailer";

		// send notification email to administrator
		mail($mail_to, $mail_subject, $mail_body, $mail_headers);

		echo "<b>A new password has been generated and sent to your email account.</b>";
	}
?>
		</th>
	</tr>
	<tr>
		<td class="links" colspan="2" align="right">
			Back to <a href="./index.php">Guestbook</a> | <a href="./admin.php">Admin Panel</a>
		</td>
	</tr>
</table>
</div>
<?php
}// end generate_and_send()


///////////////////////////////////////////////////////////////////////////////
// script main
///////////////////////////////////////////////////////////////////////////////
if(isset($HTTP_POST_VARS['action']))
{
	pageheader("$sitename - Forgot your password?");
	generate_and_send();
}
else
{
	pageheader("$sitename - Forgot your Password?","onLoad=\"document.forms['forgot_form'].elements['userid'].focus()\"");
	forgot_form();
}
pagefooter();
?>