<?php
///////////////////////////////////////////////////////////////////////////////
// File: index.php
// Purpose: displays guestbook
// Remarks: requires common.php
///////////////////////////////////////////////////////////////////////////////
// Functions:
//		string query_string(int)
//		void page_num_links()
//		void display_openbook(array)
//		void display_conventional(array)
///////////////////////////////////////////////////////////////////////////////

require("./common.php");

$start_time=get_microtime();

session_start();


///////////////////////////////////////////////////////////////////////////////
// Function: string query_string(int $page)
// Purpose: determines query string for page links
// Parameters:
//		$page - page to link to
// Returns: query string
// Global references: none
///////////////////////////////////////////////////////////////////////////////
function query_string($page)
{
	$query_string=$GLOBALS['QUERY_STRING'];
	if(ereg("page=.*",$GLOBALS['QUERY_STRING']))
	{
		$query_string=ereg_replace("page=.*", "page=$page", $query_string);
	}
	else
	{
		$query_string.="&page=$page";
	}

	return $query_string;
}// end query_string()

///////////////////////////////////////////////////////////////////////////////
// Function: void page_num_links()
// Purpose: page-spanning; displays page-numbered links
// Parameters: none
// Returns: nothing
// Global references:
//		$PHP_SELF
//		$current_page - page number of current page
//		$total_num_pages - total number of pages
///////////////////////////////////////////////////////////////////////////////
function page_num_links()
{
	global $PHP_SELF;
	global $HTTP_GET_VARS;
	global $current_page;
	global $total_num_pages;

	echo "Page: ";

	if($current_page > 1)
	// not on 1st page so display links to 1st and previous pages
	{
		$prev_page=$current_page-1;

		echo "<a href=\"$PHP_SELF?".query_string(1)."\">[ First ]";
		echo "<a href=\"$PHP_SELF?".query_string($prev_page)."\">[ < ]";
	}
	else
	{
		echo "[ First ]";
		echo "[ < ]";
	}


	/* page-numbered links code segment */
	$start=$current_page-4;		// 1st page link to display
	if($start < 1)
	{
		$start=1;
	}

	$end=$current_page+4;		// last page link to display
	if($end > $total_num_pages)
	{
		$end=$total_num_pages;
	}

	for($pg=$start; $pg <= $end; $pg++)
	{
		if($pg == $current_page)
		// do not create hyperlink for current page
		{
			echo "[ <font size=\"2\"><i>$pg</i></font> ] ";
		}
		else
		// create hyperlink to page $pg
		{
			echo "<a href=\"$PHP_SELF?".query_string($pg)."\">[ $pg ]</a> ";
		}
	}
	/* END of page-numbered links code segment */


	if($current_page < $total_num_pages)
	// not on last page so display links to last and next pages
	{
		$next_page=$current_page+1;

		echo "<a href=\"$PHP_SELF?".query_string($next_page)."\">[ > ]";
		echo "<a href=\"$PHP_SELF?".query_string($total_num_pages)."\">[ Last ]";
	}
	else
	{
		echo "[ > ]";
		echo "[ Last ]";
	}
}// end page_num_links()

///////////////////////////////////////////////////////////////////////////////
// Function: void display_openbook(array $post)
// Purpose: displays guestbook entry in $post; OpenBook style
// Parameters:
//		$post - array containing details of guestbook entry
// Returns: nothing
// Global references:
//		$HTTP_SESSION_VARS
//		$HTTP_GET_VARS
// Remarks: modify the HTML to suit your taste
///////////////////////////////////////////////////////////////////////////////
function display_openbook($post)
{
	global $HTTP_SESSION_VARS;
	global $HTTP_GET_VARS;

	if(empty($HTTP_GET_VARS['page']))
	{
		$HTTP_GET_VARS['page']=1;
	}
?>
<!-- guestbook entry table -->
<table width="<?=$GLOBALS['OB_table_width']?>" cellspacing="1" cellpadding="5">
	<tr>
		<th width="40%">Name</th>
		<th width="40%">Email</th>
		<th width="20%">Date posted</th>
	</tr>
	<tr>
		<td class="details" nowrap><?=stripslashes($post['username'])?></td>
		<td class="details" nowrap><?php if($post['useremail']) echo "<a href=\"mailto:".$post['useremail']."\">".$post['useremail']."</a>"; else echo "withheld"; ?></td>
		<td class="details" nowrap><?php echo $post['date']; ?></td>
	</tr>
	<tr>
		<td colspan="3"><span class="subject"><?php if($post['subject']) echo stripslashes($post['subject']); else echo "Guestbook Entry" ?></span><br /><?=wordwrap(stripslashes(nl2br($post['message'])),50,"\n",1)?></td>
	</tr>
	<tr>
		<td colspan="3"><?php if(isset($post['reply'])) if($post['reply']) echo "<span class=\"reply\">Reply:</span><br />", wordwrap(stripslashes(nl2br($post['reply'])),50,"\n",1); ?>
		</td>
	</tr>
	<tr>
		<td class="links" colspan="3"><?php if($post['homepage']) echo "Website: <a target=\"_blank\" href=\"http://".stripslashes($post['homepage'])."\">http://".$post['homepage']."</a>"; else echo "Website: n/a";?>
		</td>
	</tr>
	<?php
		if(isset($HTTP_SESSION_VARS['admin_name']))
		// user is administrator; display edit and delete entry options
		{
	?>
	<tr>
		<td class="edit" colspan="100%" align="left">
			<a href="./edit.php?page=<?=$HTTP_GET_VARS['page']?>&entryid=<?=$post['entryid']?>">Edit Entry / Reply</a>
		</td>
	</tr>
	<?php
		}
	?>
</table>
<!-- END guestbook entry table -->
<?php
}// end display_openbook()

///////////////////////////////////////////////////////////////////////////////
// Function: void display_conventional(array $post)
// Purpose: displays guestbook entry in $post; conventional guestbook style
// Parameters:
//		$post - array containing details of guestbook entry
// Returns: nothing
// Global references:
//		$HTTP_SESSION_VARS
//		$HTTP_GET_VARS
// Remarks: modify the HTML to suit your taste
///////////////////////////////////////////////////////////////////////////////
function display_conventional($post)
{
	global $HTTP_SESSION_VARS;
	global $HTTP_GET_VARS;

	if(empty($HTTP_GET_VARS['page']))
	{
		$HTTP_GET_VARS['page']=1;
	}
?>
<!-- guestbook entry table -->
<table width="<?=$GLOBALS['OB_table_width']?>" cellspacing="1" cellpadding="5">
	<tr>
		<th>Author</th>
		<th>Message</th>
	</tr>
	<tr>
		<td class="details" width="35%" valign="top">
			<b><?=stripslashes($post['username'])?></b>
			<br /><br /><br />
			<?php if($post['useremail']) echo "<a href=\"mailto:".$post['useremail']."\"><img src=\"./images/email_icon.gif\" /></a>"; ?>
			<?php if($post['homepage']) echo "<a target=\"_blank\" href=\"http://".stripslashes($post['homepage'])."\"><img src=\"./images/url_icon.gif\" /></a>"; ?>
			<br />
			<span class="xxsmall">Posted: <?=$post['date']?>
		</td>
		<td valign="top">
			<span class="subject"><?php if($post['subject']) echo stripslashes($post['subject']); else echo "Guestbook Entry" ?></span>
			<br />
			<?=wordwrap(stripslashes(nl2br($post['message'])),50,"\n",1)?>
			<br /><br />
			<?php if(isset($post['reply'])) if($post['reply']) echo "<hr class=\"reply\" /><span class=\"reply\">Reply:</span><br />", wordwrap(stripslashes(nl2br($post['reply'])),50,"\n",1); ?>
		</td>
	</tr>
<?php
	if(isset($HTTP_SESSION_VARS['admin_name']))
	// display edit and delete entry options if user is administrator
	{
?>
	<tr>
		<td class="edit" colspan="100%" align="left"><a href="./edit.php?page=<?=$HTTP_GET_VARS['page']?>&entryid=<?=$post['entryid']?>">Edit Entry / Reply</a></td>
	</tr>
<?php
	}
?>
</table>
<!-- END guestbook entry table -->
<?php
}// end display_conventional()



///////////////////////////////////////////////////////////////////////////////
// script main
///////////////////////////////////////////////////////////////////////////////
pageheader();

db_connect();

// retrieve total number of entries
$query="SELECT count(*) AS total_entries FROM $posts_table";
$result=mysql_query($query);
$row=mysql_fetch_array($result);
$total_entries=$row['total_entries'];	// total number of guestbook entries

// calculate total number of pages
$total_num_pages=ceil($total_entries/$OB_entries_per_page);

if(isset($HTTP_GET_VARS['page']))
{
	if($HTTP_GET_VARS['page'] > 0 && $HTTP_GET_VARS['page'] <= $total_num_pages)
	// incorrect page requested; default to 1st page
	{
		$current_page=$HTTP_GET_VARS['page'];
	}
	else
	{
		$current_page=1;
	}
}
else
// if no page value was passed, show the 1st page by default
{
	$current_page=1;
}

// retrieve guestbook entries from db
// Note: if you want to show the time use date_format(postdate,'%D %b %Y %r') instead
$query="SELECT entryid,username,useremail,homepage,subject,message,date_format(postdate,'%D %b %Y') AS date,reply "
				."FROM $posts_table "
				."ORDER BY entryid DESC "
				."LIMIT ".($current_page - 1) * $OB_entries_per_page.",".$OB_entries_per_page;
$result=mysql_query($query);
?>

<div align="center">
<h1>OpenBook</h1>
<?php
if(isset($HTTP_SESSION_VARS['admin_name']))
// if session variable $admin_name exists, then user is administrator
{
	echo "<span class=\"adminname\">Welcome to your guestbook ", $HTTP_SESSION_VARS['admin_name'], "!</span>\n";
	echo "<a href=\"./logout.php\">[Logout]</a><br />\n";
}
?>
<!-- top links table -->
<table width="70%" cellspacing="1" cellpadding="5">
	<tr>
		<th colspan="2"><a href="post.php">[Sign my guestbook]</a> | <a href="admin.php">[Admin panel] <span class="xxsmall">(restricted)</span></a> | <a href="<?=$GLOBALS['DOMAIN_URL']?>">Back to Homepage</a></th>
	</tr>
	<tr>
		<td class="subject" align="center" width="25%" nowrap>Total number of entries: <?=$total_entries?>.</td>
		<td class="subject" align="right" nowrap><?php page_num_links(); ?></td>
	</tr>
</table>
<!-- END top links table -->
<br />
<?php
if(@mysql_num_rows($result) == 0)
// no entries in guestbook
{
	echo "Your guestbook is empty!<br /><br />\n";
}
else
// display each entry stored in db
{
	$draw_hr=false;	// to indicate whether to draw <hr>

	// display guestbook entries
	while($post=mysql_fetch_array($result))
	{
		if($draw_hr) echo "<hr width=\"55%\" />\n";  // draw horizontal line separator

		$display_function="display_".$OB_display_type;
		$display_function($post);		// dynamically call function to display guestbook entries

		$draw_hr=true;
	}
}
?>
<br />
<!-- bottom links table -->
<table width="70%" cellspacing="1" cellpadding="5">
	<tr>
		<td class="subject" align="center" width="25%" nowrap>Total number of entries: <?=$total_entries?>.</td>
		<td class="subject" align="right" nowrap><?php page_num_links(); ?></td>
	</tr>
	<tr>
		<th colspan="2"><a href="post.php">[Sign my guestbook]</a> | <a href="admin.php">[Admin panel] <span class="xxsmall">(restricted)</span></a> | <a href="<?=$GLOBALS['DOMAIN_URL']?>">Back to Homepage</a></th>
	</tr>
</table>
<!-- END bottom links table -->

</div>
<br />

<?php
$stop_time=get_microtime();
$exec_time=$stop_time - $start_time;
echo "<div class=\"footer\" align=\"center\">\n";
echo "This page was generated in $exec_time seconds.";
echo "</div>\n";
pagefooter();
?>