<?php
///////////////////////////////////////////////////////////////////////////////
// File: post.php
// Purpose: 1) displays form for signing guestbook,
//			2) displays confirmation/error message upon form submission,
//			3) inserts new entry into database if successful.
// Remarks: requires common.php
///////////////////////////////////////////////////////////////////////////////
// Functions:
//		void display_form(bool,bool,bool,bool)
//		void process_form()
///////////////////////////////////////////////////////////////////////////////

require("./common.php");

session_start();

///////////////////////////////////////////////////////////////////////////////
// Function: void display_form(array $err)
// Purpose: displays form for signing guestbook
// Parameters:
//		$err - array containing erroroneous fields and error messages
// Returns: nothing
// Global references:
//		$PHP_SELF
//		$HTTP_POST_VARS
///////////////////////////////////////////////////////////////////////////////
function display_form($err=array())
{
	global $PHP_SELF;
	global $HTTP_POST_VARS;
?>

<div align="center">
<h1>Leave a Message</h1>
<?php
if(count($err))
// error in previous submission
{
	echo "<span class=\"error\">There was an error in your previous submission. Please re-enter the fields highlighted in red.</span>\n";
}
?>
<form name="sign" method="post" action="<?php echo $PHP_SELF; ?>">

<!-- form table -->
<table width="<?=$GLOBALS["OB_table_width"]?>" height="50%" cellspacing="1" cellpadding="5">
	<tr>
		<th width="30%" align="right"><?php if(in_array("username",$err)) echo "<span class=\"error\">"; ?>Name:<?php if(in_array("username",$err)) echo "</span>"; ?></th>
		<td><input name="username" type="text" size="20" maxlength="30" value="<?php if(isset($HTTP_POST_VARS["username"])) echo $HTTP_POST_VARS["username"];?>"><font color="red">*</font></td>
	</tr>
	<tr>
		<th width="30%" align="right"><?php if(in_array("useremail",$err)) echo "<span class=\"error\">"; ?>Email:<?php if(in_array("useremail",$err)) echo "</span>"; ?></th>
		<td><input name="useremail" type="text" size="30" maxlength="40" value="<?php if(isset($HTTP_POST_VARS["useremail"])) echo $HTTP_POST_VARS["useremail"];?>"></td>
	</tr>
	<tr>
		<th width="30%" align="right"><?php if(in_array("homepage",$err)) echo "<span class=\"error\">"; ?>Homepage URL:<?php if(in_array("homepage",$err)) echo "</span>"; ?></th>
		<td><b>http://</b><input name="homepage" type="text" size="35" maxlength="50" value="<?php if(isset($HTTP_POST_VARS["homepage"])) echo $HTTP_POST_VARS["homepage"];?>"></td>
	</tr>
	<tr>
		<th width="30%" align="right">Subject:</th>
		<td><input name="subject" type="text" size="40" maxlength="40" value="<?php if(isset($HTTP_POST_VARS["subject"])) echo $HTTP_POST_VARS["subject"];?>"></td>
	</tr>
	<tr>
		<th width="30%" align="right"><?php if(in_array("message",$err)) echo "<span class=\"error\">"; ?>Message:<?php if(in_array("message",$err)) echo "</span>"; ?></th>
		<td><textarea name="message" rows="5" cols="40"><?php if(isset($HTTP_POST_VARS["message"])) echo $HTTP_POST_VARS["message"];?></textarea><font color="red">*</font></td>
	</tr>
	<tr>
		<td class="buttons" colspan="2" align="center"><input name="action" type="submit" value="Add your comments!"> <input name="action" type="submit" value="Preview"> <input type="reset" value="Reset fields"></td>
	</tr>
	<tr>
		<td class="links" colspan="2" align="right">Back to <a href="./index.php">guestbook</a></td>
	</tr>
	<tr>
		<td class="none" colspan="2" align="left"><font color="red">*</font> indicates a required field</td>
	</tr>
</table>
<!-- END form table -->

</form>
</div>
<?php
}// end display_form()

///////////////////////////////////////////////////////////////////////////////
// Function: array check_form()
// Purpose: checks form fields for errors; returns array containing errorneous fields
// Parameters: none
// Returns: nothing
// Global references:
//		$HTTP_POST_VARS
///////////////////////////////////////////////////////////////////////////////
function check_form()
{
	global $HTTP_POST_VARS;

	$err=array();		//  array for storing erroroneous fields and error messages

	if(empty($HTTP_POST_VARS["username"]))
	// user name cannot be empty
	{
		$err[]="username";
	}
	if(empty($HTTP_POST_VARS["message"]))
	// message body cannot be empty
	{
		$err[]="message";
	}
	if(!empty($HTTP_POST_VARS["useremail"]))
	// check email field format if entered
	{
		$useremail=trim($HTTP_POST_VARS["useremail"]);		if(!ereg('^[0-9A-Za-z]+[\._0-9A-Za-z]*@([0-9A-Za-z-]+\.)+([0-9A-Za-z]){2,6}$',$useremail))
		{
			$err[]="useremail";
		}
	}
	if(!empty($HTTP_POST_VARS["homepage"]))
	// check homepage URL field format if entered
	{
		$homepage=trim($HTTP_POST_VARS["homepage"]);
		$homepage=preg_replace("|http://|","",$homepage);	// strip preceding "http://"
		if(!eregi('^[0-9A-Za-z]+\.([0-9A-Za-z])+',$homepage))
		{
			$err[]="homepage";
		}
	}

	return $err;
}// end check_form()

///////////////////////////////////////////////////////////////////////////////
// Function: void preview()
// Purpose: allows the user to preview his entry
// Parameters: none
// Returns: nothing
// Global references:
//		$PHP_SELF
//		$HTTP_POST_VARS
//		$sitename
///////////////////////////////////////////////////////////////////////////////
function preview()
{
	global $PHP_SELF;
	global $HTTP_POST_VARS;
	global $sitename;

	$post=$HTTP_POST_VARS;

	$post['homepage']=preg_replace("|http://|","",$post['homepage']);	// strip preceding "http://"

	$post["username"]=htmlentities($HTTP_POST_VARS["username"]);
	$post["useremail"]=htmlentities($HTTP_POST_VARS["useremail"]);
	$post["homepage"]=htmlentities($HTTP_POST_VARS["homepage"]);
	$post["homepage"]=preg_replace("|http://|","",$post['homepage']);	// strip preceding "http://"
	$post["subject"]=htmlentities($HTTP_POST_VARS["subject"]);
	$post["message"]=htmlentities($HTTP_POST_VARS["message"]);

	$err=array();		// array for storing erroroneous fields and error messages

	$err=check_form();	// check form inputs for errors

	if(count($err))
	// display form again together with error messages
	{
		pageheader("$sitename - Error in your entry...");

		display_form($err);
	}
	else
	{
?>
<div align="center">
<h1>Preview your entry</h1>
<form name="sign" method="post" action="<?php echo $PHP_SELF; ?>">

<!-- guestbook entry table -->
<table width="<?=$GLOBALS["OB_table_width"]?>" cellspacing="1" cellpadding="5">
	<tr>
		<th width="40%">Name</th>
		<th width="40%">Email</th>
		<th width="20%">Date posted</th>
	</tr>
	<tr>
		<td class="details" nowrap><?=stripslashes($post["username"])?></td>
		<td class="details" nowrap><?php if($post["useremail"]) echo "<a href=\"mailto:".$post["useremail"]."\">".$post["useremail"]."</a>"; else echo "withheld"; ?></td>
		<td class="details" nowrap><?php echo date("jS M Y"); ?></td>
	</tr>
	<tr>
		<td colspan="3"><span class="subject"><?php if($post["subject"]) echo stripslashes($post["subject"]); else echo "Guestbook Entry" ?></span><br /><?=wordwrap(stripslashes(nl2br($post["message"])),50,"\n",1)?></td>
	</tr>
	<tr>
		<td class="links" colspan="3"><?php if($post["homepage"]) echo "Website: <a target=\"_blank\" href=\"http://".$post["homepage"]."\">http://".$post["homepage"]."</a>"; else echo "Website: n/a";?>
		</td>
	</tr>
	<tr>
		<td class="buttons" colspan="3" align="center"><input name="action" type="submit" value="Add your comments!"> <input type="submit" value="Make Changes""></td>
	</tr>
</table>
<!-- END guestbook entry table -->

<input name="username" type="hidden" value="<?=$post["username"]?>">
<input name="useremail" type="hidden" value="<?=$post["useremail"]?>">
<input name="subject" type="hidden" value="<?=$post["subject"]?>">
<input name="message" type="hidden" value="<?=$post["message"]?>">
<input name="homepage" type="hidden" value="<?=$post["homepage"]?>">
</form>
</div>
<?php
	}
}// end preview()


///////////////////////////////////////////////////////////////////////////////
// Function: void process_form()
// Purpose: processes the form and 
//			1) displays error message if submission is incorrect,
//			2) inserts entry into database and displays confirmation if successful.
// Parameters: none
// Returns: nothing
// Global references:
//		$PHP_SELF
//		$HTTP_POST_VARS
//		$sitename - name of site
//		$posts_table - name of table containing guestbook entries
//		$admin_table - name of table containing admin records
///////////////////////////////////////////////////////////////////////////////
function process_form()
{
	global $PHP_SELF;
	global $HTTP_POST_VARS;
	global $sitename;
	global $posts_table, $admin_table;

	$err=array();		// array for storing erroroneous fields and error messages

	$err=check_form();	// check form inputs for errors

	if($err)
	// display form again together with error messages
	{
		pageheader("$sitename - Error in your entry...");

		display_form($err);
	}
	else
	// insert guestbook entry into database
	{
		// remove any html or php tags
		$username=addslashes(htmlentities($HTTP_POST_VARS["username"]));
		$useremail=htmlentities($HTTP_POST_VARS["useremail"]);
		$homepage=addslashes(htmlentities(preg_replace("|http://|","",$HTTP_POST_VARS["homepage"])));
		$subject=addslashes(htmlentities($HTTP_POST_VARS["subject"]));
		$message=addslashes(htmlentities($HTTP_POST_VARS["message"]));

		db_connect();

/* code for converting server time to user locale time
		$time_offset="08";	// offset from server time in hours
		$time_offset="00000000".$time_offset."0000";

		$query="INSERT INTO $posts_table VALUES('','$username','$useremail','$homepage','$subject','$message',NOW()+$time_offset)";
*/

		$query="INSERT INTO $posts_table VALUES('','$username','$useremail','$homepage','$subject','$message',NULL,NULL)";
		$result=mysql_query($query);
		if(!$result)
		{
			pageheader("$sitename - Error processing your entry...");
			die("There has been an error entering your entry into the database.<br />If this error persists, please contact the administrator.<br /><br />Click <a href=\"./index.php\">here</a> to return to the guestbook.");
		}
		else
		{
			if($GLOBALS["OB_mail_to_admin"])
			// email notification to admin if specified
			{
				db_connect();

				$query="SELECT email FROM $admin_table";
				$result=mysql_query($query);

				// mail-to-admin variables
				$mail_list=array();
				// construct list of admin email addresses
				while($row=mysql_fetch_array($result))
				{
					$mail_list[]=$row["email"];	// insert email address in current row
				}
				$mail_to=implode(",", $mail_list);	// convert into string separated by commas

				$mail_subject="$username has signed your guestbook!";

				$mail_body="$username has made an entry into your guestbook!\n\n";
				$mail_body.="Subject:\n$subject\n\n";
				$mail_body.="Message:\n$message\n\n\n";
				
				$mail_headers="From: OpenBook Mailer <no-reply@openbook.mailer>\n";
				$mail_headers.="X-Mailer: OpenBook Mailer";

				// send notification email to administrator
				mail($mail_to, $mail_subject, $mail_body, $mail_headers);
			}

			redirectheader();

			echo "<div align=\"center\">\n";
			echo "<h1>Entry saved</h1>\n";
			echo "Thank you, <b>";
			echo htmlentities($HTTP_POST_VARS["username"]);
			echo "</b>, for signing my guestbook.<br />\n";
			echo "Your comments have been saved into the database.<br />\n";
			echo "<br />You'll be taken to the guestbook.<br />\n";
			echo "Alternatively, you can click <a href=\"./index.php\">here</a> if you can't wait.\n";
			echo "</div>\n";
		}
	}
}// end process_form()



///////////////////////////////////////////////////////////////////////////////
// script main
///////////////////////////////////////////////////////////////////////////////
if(empty($HTTP_POST_VARS["action"]))
{
	$HTTP_POST_VARS["action"]="";
}
switch($HTTP_POST_VARS["action"])
{
	case "Add your comments!":
		// processes submission of form
		process_form();
		break;
	case "Preview":
		// show preview of entry
		pageheader("$sitename - Preview");
		preview();
		break;
	default:
		// displays form for signing guestbook
		pageheader("Sign my Guestbook!","onLoad=\"document.forms['sign'].elements['username'].focus()\"");
		display_form();
		break;
}
pagefooter();
?>