<?php
///////////////////////////////////////////////////////////////////////////////
// File: profile.php
// Purpose: to allow the administrator to change his profile
///////////////////////////////////////////////////////////////////////////////
// Functions:
//		void display_form(int $userid_error,int $email_error,int $password_error)
///////////////////////////////////////////////////////////////////////////////

require("./common.php");

session_start();

///////////////////////////////////////////////////////////////////////////////
// Function: void display_form(int $userid_error,int $email_error,int $password_error)
// Purpose: displays form for editing admin profile
// Parameters:
//		$userid_error - to indicate error in userid format (default: 0)
//		$email_error - to indicate error in email address format (default: 0)
//		$password_error - to indicate error in password format (default: 0)
// Returns: nothing
// Global references:
//		$PHP_SELF
//		$HTTP_SESSION_VARS
///////////////////////////////////////////////////////////////////////////////
function display_form($userid_error=0,$email_error=0,$password_error=0)
{
	global $PHP_SELF;
	global $HTTP_SESSION_VARS;

	// localise global variables
	$sitename=$GLOBALS['sitename'];
	$admin_table=$GLOBALS['admin_table'];

	$admin_name=$HTTP_SESSION_VARS['admin_name'];

	pageheader("$sitename - Profile","onLoad=\"document.forms['profile_form'].elements['new_userid'].focus()\"");

	db_connect();

	$query="SELECT userid,password,email FROM $admin_table WHERE userid='$admin_name'";
	$result=mysql_query($query);
	$admin_data=mysql_fetch_array($result);
?>

<div align="center">
<h1>Edit Your Profile</h1>
<?php
if($userid_error || $email_error || $password_error)
// error in previous submission
{
	echo "<span class=\"error\">There was an error in your previous submission. Please re-enter the fields highlighted in red.</span>\n";
}
?>
<form name="profile_form" method="post" action="<?=$PHP_SELF?>">
<input name="action" type="hidden" value="change_profile">
<input name="userid" type="hidden" value="<?=$admin_data['userid']?>">

<!-- form table -->
<table width="<?=$GLOBALS['OB_table_width']?>" cellspacing="1" cellpadding="5">
	<tr>
		<th align="right"><?php if($userid_error) echo "<span class=\"error\">"; ?>User ID:<?php if($userid_error) echo "</span>"; ?></th>
		<td>
			<input name="new_userid" type="text" value="<?=$admin_data['userid']?>" onFocus="this.select()" size="12" maxlength="12">
			<br />4-12 alphanumeric characters
		</td>
	</tr>
	<tr>
		<th align="right"><?php if($email_error) echo "<span class=\"error\">"; ?>Email address:<?php if($email_error) echo "</span>"; ?></th>
		<td><input name="new_email" type="text" value="<?=$admin_data['email']?>" size="30" maxlength="40"></td>
	</tr>
	<tr>
		<th align="right"><?php if($password_error) echo "<span class=\"error\">"; ?>New Password:<?php if($password_error) echo "</span>"; ?></th>
		<td>
			<input name="new_password1" type="password" size="12" maxlength="12">
			<br />Fill in this field only if you want to change your password. <br />4-12 alphanumeric characters
		</td>
	</tr>
	<tr>
		<th align="right"><?php if($password_error) echo "<span class=\"error\">"; ?>Re-enter Password:<?php if($password_error) echo "</span>"; ?></th>
		<td><input name="new_password2" type="password" size="12" maxlength="12"></td>
	</tr>
	<tr>
		<td class="buttons" colspan="2" align="right"><input type="submit" value="Save changes"> <input type="reset" value="Reset"></td>
	</tr>
	<tr>
		<td class="links" colspan="2" align="right">
			Back to <a href="./index.php">Guestbook</a> | <a href="./admin.php">Admin Panel</a>
		</td>
	</tr>
</table>
<!-- END form table -->

</form>
</div>
<?php
}// end display_form()

///////////////////////////////////////////////////////////////////////////////
// Function: void change_profile()
// Purpose: processes form for changing profile
// Parameters: none
// Returns: nothing
// Global references:
//		$HTTP_POST_VARS
//		$HTTP_SESSION_VARS
///////////////////////////////////////////////////////////////////////////////
function change_profile()
{
	global $HTTP_POST_VARS;
	global $HTTP_SESSION_VARS;

	// localise global variables
	$sitename=$GLOBALS['sitename'];
	$admin_table=$GLOBALS['admin_table'];

	// variables POSTed from form
	$new_userid=$HTTP_POST_VARS['new_userid'];
	$new_email=$HTTP_POST_VARS['new_email'];
	$new_password1=$HTTP_POST_VARS['new_password1'];
	$new_password2=$HTTP_POST_VARS['new_password2'];

	$userid_error=0;		// flag to indicate error in userid format
	$email_error=0;			// flag to indicate error in email address
	$password_error=0;	// flag to indicate error in password format

	if(!eregi('^[0-9a-z]{4,}$',$new_userid))
	// check userid is alphanumeric and at least 4 char
	{
	$userid_error=1;
	}
	if(!ereg('^[0-9a-z]+@([0-9a-z-]+\.)+([0-9a-z]){2,4}$',$new_email))
	// check email address format
	{
	$email_error=1;
	}

	if($new_password1)
	// password change requested
	{
		if(!($new_password1 == $new_password2) || !ereg('^[0-9A-Za-z]{4,}$',$new_password1))
		// both password fields do not match match OR 
		// format of password is not alphanumeric and at least 4 char
		{
			$password_error=1;
		}
	}

	if($userid_error || $email_error || $password_error)
	// error(s) in user input
	{
		display_form($userid_error,$email_error,$password_error);
	}
	else
	// no errors so update records in database
	{
		$admin_name=$HTTP_SESSION_VARS['admin_name'];

		$link_id=db_connect();

		if(!$new_password1)
		// password unchanged; don't update
		{
			$query="UPDATE $admin_table "
							."SET userid='$new_userid', "
							."email='$new_email' "
							."WHERE userid='$admin_name'";
		}
		else
		// new password
		{
			$query="UPDATE $admin_table "
							."SET userid='$new_userid', "
							."password=PASSWORD('$new_password1'), "
							."email='$new_email' "
							."WHERE userid='$admin_name'";
		}
		$result=mysql_query($query);

		redirectheader("./admin.php");

		// update session variable $admin_name to reflect new changes
		$HTTP_SESSION_VARS['admin_name']=$new_userid;

		echo "<div align=\"center\"\n>";
		echo "<h1>Profile Changed</h1>\n";
		echo "Profile successfully changed.<br />\n";
		echo "You'll be taken back to the admin panel.\n";
		echo "<br /><br />\n";
		echo "Alternatively, you can click <a href=\"./admin.php\">here</a> if you can't wait.\n";
		echo "</div>\n";
	}
}// end change_profile()


///////////////////////////////////////////////////////////////////////////////
// script main
///////////////////////////////////////////////////////////////////////////////
if($HTTP_SESSION_VARS['admin_name'])
// IMPT: check if user is administrator first
{
 	if($HTTP_POST_VARS['action']=="change_profile")
	// process confirmation of profile change
	{
		change_profile();
	}
	else
	// $action not 'change_profile'; display form for editing profile
	{
		display_form();
	}
}
else
// user is NOT logged in as administrator
{
	not_logged_error();
}

pagefooter();
?>