<?php
/*
 * This file holds the Dutch translation of PHP Weather. To use it,
 * just include it in the main phpweather.inc file.
 *
 * Author: Nicky Haan <nicky@netcase.nl>
 */

/* Unsets old language variables and loads new ones. */
if (isset($strings)) {
  /* The strings array is loaded - assume the same for the rest. */
  unset($strings);
  unset($wind_dir_text_short_array);
  unset($wind_dir_text_array);
  unset($weather_array);
  unset($cloud_condition_array);
}
/* Load the new strings */

$strings = array(
  'no_data'               => '<blockquote><p>Helaas, er is geen data beschikbaar voor %s.</p></blockquote>',
  'mm_inches'             => '<b>%s</b> mm (<b>%s</b> inch',
  'precip_a_trace'        => 'een spoor',
  'precip_there_was'      => 'Er was %s neerslag ',
  'sky_str_format1'       => 'er was <b>%s</b> op een hoogte van <b>%s</b> meter (<b>%s</b> voet)',
  'sky_str_clear'         => 'er was <b>geen</b> bewolking',
  'sky_str_format2'       => ', <b>%s</b> op een hoogte van <b>%s</b> meter (<b>%s</b> voet) en <b>%s</b> op een hoogte van <b>%s</b> meter (<b>%s</b> voet)',
  'sky_str_format3'       => ' en <b>%s</b> op een hoogte van <b>%s</b> meter (<b>%s</b> voet)',
  'sky_cavok'             => 'There are no clouds below <b>1,524</b> meter (<b>5,000</b> feet)',
  'clouds'                => ' bewolking',
  'clouds_cb'             => ' buienwolken',
  'clouds_tcu'            => ' stapelwolking',
  'visibility_format'     => 'De zichtbaarheid was <b>%s</b> kilometer (<b>%s</b> mijl).',
  'wind_str_format1'      => 'met windsnelheden van <b>%s</b> meter per seconde(<b>%s</b> mijl per uur)',
  'wind_str_format2'      => ', met vlagen tot <b>%s</b> meter per seconde (<b>%s</b> mijl per uur),',
  'wind_str_format3'      => ' vanuit <b>%s</b>',
  'wind_str_calm'         => '<b>kalm</b>',
  'wind_vrb_long'         => 'variable richtingen',
  'wind_vrb_short'        => 'VAR',
  'precip_last_hour'      => 'in het laatste uur. ',
  'precip_last_6_hours'   => 'in de laatste 3 tot 6 uur. ',
  'precip_last_24_hours'  => 'in de laatste 24 uur. ',
  'precip_snow'           => 'Er is <b>%s</b> mm (<b>%s</b> inch) sneeuw op de grond. ',
  'temp_min_max_6_hours'  => 'De maximum en minumum temperaturen over de laatste 6 uur waren <b>%s</b> en <b>%s</b> graden Celsius (<b>%s</b> en <b>%s</b> graden Fahrenheit).',
  'temp_max_6_hours'      => 'De maximum temperatuur over de laatste 6 uur was <b>%s</b> graden Celsius (<b>%s</b> graden Fahrenheit). ',
  'temp_min_6_hours'      => 'De minumum temperatuur over de laatste 6 uur was <b>%s</b> graden Celsius (<b>%s</b> graden Fahrenheit). ',
  'temp_min_max_24_hours' => 'De maximum en minumum temperaturen over de laatste 24 uur waren <b>%s</b> en <b>%s</b> graden Celsius (<b>%s</b> en <b>%s</b> graden Fahrenheit). ',
  'runway_vis'            => 'The visibility for runway <b>%s</b> is <b>%s</b> meters (<b>%s</b> feet).',
  'runway_vis_min_max'    => 'The visibility for runway <b>%s</b> varies between <b>%s</b> meters (<b>%s</b> feet) and <b>%s</b> meters (<b>%s</b> feet).',
  'light'                 => 'Ligt ',
  'moderate'              => 'Gematigd ',
  'Heavy'                 => 'Zwaar ',
  'nearby'                => 'Dichtbij ',
  'current_weather'       => 'Het huidige weer is <b>%s</b>. ',
  'pretty_print_metar'    => '<blockquote><p><b>%s</b> minuten geleden, om <b>%s</b> UTC, de wind blies %s nabij %s. De temperatuur was <b>%s</b> graden Celsius (<b>%s</b> graden Fahrenheit), en de barometerdruk was <b>%s</b> hPa (<b>%s</b> inHg). De relatieve vochtigheid was <b>%s%%</b>. %s %s %s %s %s</p></blockquote>'
 );

$wind_dir_text_short_array = array(
  'N',
  'N/NO',
  'NO',
  'O/NO',
  'O',
  'O/ZO',
  'ZO',
  'Z/ZO',
  'Z',
  'Z/ZW',
  'ZW',
  'W/ZW',
  'W',
  'W/NW',
  'NW',
  'N/NW',
  'N');

$wind_dir_text_array = array(
  'Noord',
  'Noord/Noordoost',
  'Noordoost',
  'Oost/Noordoost',
  'Oost',
  'Oost/Zuidoost',
  'Zuidoost',
  'Zuid/Zuidoost',
  'Zuid',
  'Zuid/Zuidwest',
  'Zuidwest',
  'West/Zuidwest',
  'West',
  'West/Noordwest',
  'Noordwest',
  'North/Noordwest',
  'Noord');

$weather_array = array(
  'PR' => 'Deeltje ',
  'BC' => 'Flarden ',
  'DR' => 'Laag optrekkende ',
  'BL' => 'Blazen ',
  'SH' => 'Bui(en) ',
  'TS' => 'Onweersbui ',
  'FZ' => 'Vriest',
  'DZ' => 'Motregen ',
  'RA' => 'Regen ',
  'SN' => 'Sneeuw ',
  'SG' => 'Motsneeuw ',
  'IC' => 'IJs Kristallen ',
  'PE' => 'IJs Hagel ',
  'GR' => 'Hagel ',
  'GS' => 'Fijne Hagel en/of Motsneeuw ',
  'UP' => 'Onbekend ',
  'BR' => 'Mist ',
  'FG' => 'Mist ',
  'FU' => 'Rook ',
  'VA' => 'Vulkanische As ',
  'DU' => 'Wijdeverspreide Stofdeeltjes ',
  'SA' => 'Zand ',
  'HZ' => 'Nevel ',
  'PY' => 'Nevel',
  'PO' => 'StuifZand/-Stof ',
  'SQ' => 'Vlagen ',
  'FC' => 'Trechtervormige Tornado Waterhoos  ',
  'SS' => 'Zandstorm/Stofstorm ');

$cloud_condition_array = array(
  'SKC' => 'helder',
  'CLR' => 'helder',
  'VV'  => 'vertikale zichtbaarheid',
  'FEW' => 'weinig',
  'SCT' => 'versprijde',
  'BKN' => 'gebroken',
  'OVC' => 'betrekkelijk');
?>
